/** @file   smallwormalien.h
 * @brief   Declaration of SmallWormAlien class
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:42 $
 * @author  Tomi Lamminsaari
 */
 
#ifndef H_WWW_SMALLWORMALIEN_H
#define H_WWW_SMALLWORMALIEN_H

#include "alien.h"


namespace WeWantWar {


/** @class  SmallWormAlien
 * @brief   Small wormlike alien that shoots.
 * @author  Tomi Lamminsaari
 *
 * SmallWormAlien - class represents the little worm-like alien that
 * emits some bullets as player goes too close to it.
 */
class SmallWormAlien : public Alien
{
public:

  ///
  /// Static members
  /// ==============
  
  /** Number of bullets this alien shoots. */
  static const int NUM_OF_BULLETS;
  
  /** How far the bullets fly. */
  static const float BULLET_RANGE;
  
  
  ///
  /// Constructor, destructor
  /// =======================
  
  /** Constructor.
   */
  SmallWormAlien();
  
  /** Destructor.
   */
  virtual ~SmallWormAlien();
  
  
  ///
  /// Methods
  /// =======
  
  /** Reimplemented update-method. Moves and controls this alien.
   */
  virtual void update();

  /** Kills this object.
   */
  virtual void kill();

  /** Makes sound.
   * @param     id                ID of the sound we should make.
   */
  virtual void makeSound( GameObject::SoundID id ) const;
  
  /** This alien got hit by given bullet. The bullets can go through the
   * Alien if it was shot by another alien.
   * @param     pB                Pointer to bullet that hit us.
   * @return    'true' if this bullet did hit us. 'false' means it went
   *            through.
   */
  virtual bool hitByBullet( Bullet* pB );
  
  
  ///
  /// Getter methods
  /// ==============

  /** Returns the type of this object.
   * @return    Type of this object.
   * @see       GameObject - class for more information.
   */
  virtual ObjectID::Type objectType() const;
  
  /** Returns the redraw priority
   * @return    Redraw priority
   */
  virtual int redrawPriority() const;
  
protected:

  /** Does the shooting.
   */
//  virtual void doShooting();
  
  /** Sets the requested animation
   * @param     animID            The id-code of the new animation
   */
  virtual void setCorrectAnimation( int animID );
  
  /** Attacks the target.
   */
  virtual void attack();
  
  
  ///
  /// Members
  /// =======
  
  /** The crawling speed of the worm. */
  eng2d::Vec2D  m_spdVec;
  
  /** Reloading delay. */
  int m_reloadingDelay;
  
  
  
private:
  /** Copy constructor.
   */
  SmallWormAlien( const SmallWormAlien& rO );
  /** Operator =
   */
  SmallWormAlien& operator = ( const SmallWormAlien& rO );
};

};  // end of namespace


#endif // SmallWormAlien_H

/**
 * Version history
 * ===============
 * $Log: smallwormalien.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:42  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:16+02  lamminsa
 * Initial revision
 *
 */
 
